/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.dto.MKeisanDto;

public class MKeisanDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE	= "M_KEISAN";
	public static final String KEY_1	= "KTNEN";		//^vZN

	// 
	public static final String COL_KTNEN 		= "KTNEN";		//^vZN
	public static final String COL_KTTUKI  	= "KTTUKI";		//^vZ
	public static final String COL_KSNEN  	= "KSNEN";		//^xN
	public static final String COL_KSTUKI  	= "KSTUKI";		//^x
	public static final String COL_KSHI  		= "KSHI";		//^x
	public static final String COL_KKANRYOU  	= "KKANRYOU";	//^
	public static final String COL_STNEN  	= "STNEN";		//ܗ^vZN
	public static final String COL_STTUKI  	= "STTUKI";		//ܗ^vZ
	public static final String COL_SSNEN  	= "SSNEN";		//ܗ^xN
	public static final String COL_SSTUKI  	= "SSTUKI";		//ܗ^x
	public static final String COL_SSHI  		= "SSHI";		//ܗ^x
	public static final String COL_SKANRYOU  	= "SKANRYOU";	//ܗ^
	public static final String COL_NTNEN  	= "NTNEN";		//NvZN
	public static final String COL_NKANRYOU  	= "NKANRYOU";	//N
	public static final String COL_TTNEN  	= "TTNEN";		//ZvZN
	public static final String COL_TTTUKI  	= "TTTUKI";		//ZvZ
	public static final String COL_TKANRYOU  	= "TKANRYOU";	//Z芮
	public static final String COL_GTNEN  	= "GTNEN";		//όvZN
	public static final String COL_GTTUKI  	= "GTTUKI";		//όvZ
	public static final String COL_GKANRYOU  	= "GKANRYOU";	//ϊ

	/**
	 * RXgN^
	 */
	public MKeisanDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List mappingAll() throws SQLException {
		List<MKeisanDto> all = new ArrayList<MKeisanDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return m_keisanDto m_keisanR[h
	 * @throws SQLException
	 */
	private MKeisanDto mapping() throws SQLException {
		MKeisanDto dto = new MKeisanDto();
		dto.setKTNen 	(rs.getInt    (COL_KTTUKI  	));	//^vZN
		dto.setKTTuki 	(rs.getInt    (COL_KSNEN  	));	//^vZ
		dto.setKSNen 	(rs.getInt    (COL_KSTUKI  	));	//^xN
		dto.setKSTuki 	(rs.getInt    (COL_KSHI  	));	//^x
		dto.setKShi 	(rs.getInt    (COL_KKANRYOU ));	//^x
		dto.setKKanryou (rs.getString (COL_KKANRYOU ));	//^
		dto.setSTNen 	(rs.getInt    (COL_STNEN  	));	//ܗ^vZN
		dto.setSTTuki 	(rs.getInt    (COL_STTUKI  	));	//ܗ^vZ
		dto.setSSNen 	(rs.getInt    (COL_SSNEN  	));	//ܗ^xN
		dto.setSSTuki 	(rs.getInt    (COL_SSTUKI  	));	//ܗ^x
		dto.setSSHi 	(rs.getInt    (COL_SSHI  	));	//ܗ^x
		dto.setSKanryou (rs.getString (COL_SKANRYOU ));	//ܗ^
		dto.setNTNen 	(rs.getInt    (COL_NTNEN  	));	//NvZN
		dto.setNKanryou (rs.getString (COL_NKANRYOU ));	//N
		dto.setTTNen 	(rs.getInt    (COL_TTNEN  	));	//ZvZN
		dto.setTTTuki 	(rs.getInt    (COL_TTTUKI  	));	//ZvZ
		dto.setTKanryou (rs.getString (COL_TKANRYOU ));	//Z芮
		dto.setGTNen 	(rs.getInt    (COL_GTNEN  	));	//όvZN
		dto.setGTTuki 	(rs.getInt    (COL_GTTUKI  	));	//όvZ
		dto.setGKanryou (rs.getString (COL_GKANRYOU ));	//ϊ
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param ktnen ^vZN(L[)
	 * @return m_keisanDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKeisanDto findForKey(
			String ktnen
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, ktnen);
			executeQuery();
			MKeisanDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @return m_keisanDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKeisanDto findForUpdate(
			String ktnen
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, ktnen);
			executeQuery();
			MKeisanDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * Sf[^擾
	 * @return dto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKeisanDto findForCalc(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()));
			executeQuery();
			MKeisanDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param ktnen ^vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String ktnen
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KTTUKI  );
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   ktnen  );
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MKeisanDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto,true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(MKeisanDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto,false);
			setParam(index++, dto.getKTNen());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(MKeisanDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKTNen());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(MKeisanDto dto,boolean isInsert) throws SQLException {
		setParam(index++, dto.getKTNen());		//^vZN
		setParam(index++, dto.getKTTuki());		//^vZ
		setParam(index++, dto.getKSNen());		//^xN
		setParam(index++, dto.getKSTuki());		//^x
		setParam(index++, dto.getKShi());		//^x
		setParam(index++, dto.getKKanryou());	//^
		setParam(index++, dto.getSTNen());		//ܗ^vZN
		setParam(index++, dto.getSTNen());		//ܗ^vZ
		setParam(index++, dto.getSSNen());		//ܗ^xN
		setParam(index++, dto.getSSTuki());		//ܗ^x
		setParam(index++, dto.getSSHi());		//ܗ^x
		setParam(index++, dto.getSKanryou());	//ܗ^
		setParam(index++, dto.getNTNen());		//NvZN
		setParam(index++, dto.getNKanryou());	//N
		setParam(index++, dto.getTTNen());		//ZvZN
		setParam(index++, dto.getTTTuki());		//ZvZ
		setParam(index++, dto.getTKanryou());	//Z芮
		setParam(index++, dto.getGTNen());		//όvZN
		setParam(index++, dto.getGTTuki());		//όvZ
		setParam(index++, dto.getGKanryou());	//ϊ
		setCommonParams(isInsert);
	}

}
